(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w245, h249,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
How Hard is Factoring on a Classical Computer?
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams 
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.727124 0.231363 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.001)] -0.0125 .03303 1 0 0 Minner Mrotsboxa
[(0.005)] -0.0125 .19475 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .2644 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .42611 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .49576 1 0 0 Minner Mrotsboxa
[(Time to Find Factors of n)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .03303 m
1 .03303 L
s
P
p
0 0 .5 r
.001 w
0 .19475 m
1 .19475 L
s
P
p
0 0 .5 r
.001 w
0 .2644 m
1 .2644 L
s
P
p
0 0 .5 r
.001 w
0 .42611 m
1 .42611 L
s
P
p
0 0 .5 r
.001 w
0 .49576 m
1 .49576 L
s
P
p
0 0 .5 r
.001 w
0 .10268 m
1 .10268 L
s
P
p
0 0 .5 r
.001 w
0 .14342 m
1 .14342 L
s
P
p
0 0 .5 r
.001 w
0 .17233 m
1 .17233 L
s
P
p
0 0 .5 r
.001 w
0 .21307 m
1 .21307 L
s
P
p
0 0 .5 r
.001 w
0 .22856 m
1 .22856 L
s
P
p
0 0 .5 r
.001 w
0 .24198 m
1 .24198 L
s
P
p
0 0 .5 r
.001 w
0 .25381 m
1 .25381 L
s
P
p
0 0 .5 r
.001 w
0 .33405 m
1 .33405 L
s
P
p
0 0 .5 r
.001 w
0 .37479 m
1 .37479 L
s
P
p
0 0 .5 r
.001 w
0 .40369 m
1 .40369 L
s
P
p
0 0 .5 r
.001 w
0 .44443 m
1 .44443 L
s
P
p
0 0 .5 r
.001 w
0 .45992 m
1 .45992 L
s
P
p
0 0 .5 r
.001 w
0 .47334 m
1 .47334 L
s
P
p
0 0 .5 r
.001 w
0 .48517 m
1 .48517 L
s
P
p
0 0 .5 r
.001 w
0 .56541 m
1 .56541 L
s
P
p
0 0 .5 r
.001 w
0 .60615 m
1 .60615 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .03303 m
.00625 .03303 L
s
P
[(0.001)] -0.0125 .03303 1 0 0 Minner Mrotshowa
p
.002 w
0 .19475 m
.00625 .19475 L
s
P
[(0.005)] -0.0125 .19475 1 0 0 Minner Mrotshowa
p
.002 w
0 .2644 m
.00625 .2644 L
s
P
[(0.01)] -0.0125 .2644 1 0 0 Minner Mrotshowa
p
.002 w
0 .42611 m
.00625 .42611 L
s
P
[(0.05)] -0.0125 .42611 1 0 0 Minner Mrotshowa
p
.002 w
0 .49576 m
.00625 .49576 L
s
P
[(0.1)] -0.0125 .49576 1 0 0 Minner Mrotshowa
p
.001 w
0 .10268 m
.00375 .10268 L
s
P
p
.001 w
0 .14342 m
.00375 .14342 L
s
P
p
.001 w
0 .17233 m
.00375 .17233 L
s
P
p
.001 w
0 .21307 m
.00375 .21307 L
s
P
p
.001 w
0 .22856 m
.00375 .22856 L
s
P
p
.001 w
0 .24198 m
.00375 .24198 L
s
P
p
.001 w
0 .25381 m
.00375 .25381 L
s
P
p
.001 w
0 .33405 m
.00375 .33405 L
s
P
p
.001 w
0 .37479 m
.00375 .37479 L
s
P
p
.001 w
0 .40369 m
.00375 .40369 L
s
P
p
.001 w
0 .44443 m
.00375 .44443 L
s
P
p
.001 w
0 .45992 m
.00375 .45992 L
s
P
p
.001 w
0 .47334 m
.00375 .47334 L
s
P
p
.001 w
0 .48517 m
.00375 .48517 L
s
P
p
.001 w
0 .56541 m
.00375 .56541 L
s
P
p
.001 w
0 .60615 m
.00375 .60615 L
s
P
[(Time to Find Factors of n)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .03303 m
1 .03303 L
s
P
p
.002 w
.99375 .19475 m
1 .19475 L
s
P
p
.002 w
.99375 .2644 m
1 .2644 L
s
P
p
.002 w
.99375 .42611 m
1 .42611 L
s
P
p
.002 w
.99375 .49576 m
1 .49576 L
s
P
p
.001 w
.99625 .10268 m
1 .10268 L
s
P
p
.001 w
.99625 .14342 m
1 .14342 L
s
P
p
.001 w
.99625 .17233 m
1 .17233 L
s
P
p
.001 w
.99625 .21307 m
1 .21307 L
s
P
p
.001 w
.99625 .22856 m
1 .22856 L
s
P
p
.001 w
.99625 .24198 m
1 .24198 L
s
P
p
.001 w
.99625 .25381 m
1 .25381 L
s
P
p
.001 w
.99625 .33405 m
1 .33405 L
s
P
p
.001 w
.99625 .37479 m
1 .37479 L
s
P
p
.001 w
.99625 .40369 m
1 .40369 L
s
P
p
.001 w
.99625 .44443 m
1 .44443 L
s
P
p
.001 w
.99625 .45992 m
1 .45992 L
s
P
p
.001 w
.99625 .47334 m
1 .47334 L
s
P
p
.001 w
.99625 .48517 m
1 .48517 L
s
P
p
.001 w
.99625 .56541 m
1 .56541 L
s
P
p
.001 w
.99625 .60615 m
1 .60615 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
.02381 .08436 Mdot
.15986 .01472 Mdot
.29592 .08436 Mdot
.43197 .28682 Mdot
.56803 .2994 Mdot
.70408 .42443 Mdot
.84014 .45248 Mdot
.97619 .60332 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = input; initialization; preserveAspect]
*)
Off[General::spell1]
(*
:[font = text; inactive; locked; preserveAspect]
Figure showing how the computational time needed to factor an integer grows with the "size" of the integer. An explanation is given in this Notebook.
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; preserveAspect; startGroup]
The FactorInteger Command
:[font = text; inactive; preserveAspect]
To break a message encrypted using RSA public-key cryptography, it is necessary to determine the factors of a large integer.  We can use the built-in function FactorInteger to explore how the cost of factoring scales up with the number of bits needed to describe the integer beingfactored. The number of bits in the integer is usually taken to be a measure of the "size" of the integer.
:[font = text; inactive; preserveAspect]
The FactorInteger command works as follows:
:[font = input; preserveAspect; startGroup]
?FactorInteger
:[font = print; inactive; preserveAspect; endGroup]
FactorInteger[n] gives a list of the prime factors of the integer n,
   together with their exponents.
:[font = text; inactive; preserveAspect]
So to factor the integer 566082458573800 you would enter:
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
FactorInteger[566082458573800]
:[font = output; output; inactive; preserveAspect; endGroup]
{{2, 3}, {5, 2}, {7, 4}, {17, 1}, {37, 5}}
;[o]
{{2, 3}, {5, 2}, {7, 4}, {17, 1}, {37, 5}}
:[font = text; inactive; preserveAspect; endGroup]
This is Mathematica's representation of the factorization. A more readable factorization is given by reformatting this output using our FactorIntegerProduct command:
;[s]
3:0,0;8,1;19,0;166,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,9,Times,2,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Definition of FactorIntegerProduct hidden here ...
:[font = input; preserveAspect; endGroup]
FactorIntegerProduct[x_]:=
	Apply[Times, 
	      Map[#[[1]]^ToString[#[[2]]]&, FactorInteger[x]]]
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
FactorIntegerProduct[566082458573800]
:[font = output; output; inactive; preserveAspect; endGroup]
2^"3"*5^"2"*7^"4"*17^"1"*37^"5"
;[o]
 3  2  4   1   5
2  5  7  17  37
:[font = text; inactive; preserveAspect; endGroup; endGroup]
This looks much better to the eye.
:[font = section; inactive; preserveAspect; startGroup]
Timing FactorInteger
:[font = text; inactive; preserveAspect]
To determine how long it takes Mathematica to factor an integer, use the TimeToFactorInteger command:
;[s]
3:0,0;31,1;42,0;102,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,9,Times,2,12,0,0,0;
:[font = input; initialization; preserveAspect]
*)
TimeToFactorInteger[n_]:=
	Timing[FactorInteger[n]][[1]]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
TimeToFactorInteger[1234567891234567891234567879]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
0.25*Second
;[o]
0.25 Second
:[font = section; inactive; preserveAspect; startGroup]
The "Size" of an Integer
:[font = text; inactive; preserveAspect]
The size of an integer is given by the number of bits needed to define the integer. This can be determined using SizeOfInteger:
:[font = input; initialization; preserveAspect]
*)
SizeOfInteger[n_]:=
	Length[IntegerDigits[n,2]] Bits
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
SizeOfInteger[12345]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
14*Bits
;[o]
14 Bits
:[font = section; inactive; preserveAspect; startGroup]
A Random Integer of a Certain Size
:[font = input; initialization; preserveAspect]
*)
RandomNBitInteger[n_]:=
	Random[Integer, {2^(n-1), 2^n - 1}]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
RandomNBitInteger[20]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
567280
;[o]
567280
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
Let's test our function on n=40 bits.
:[font = input; initialization; preserveAspect]
*)
Needs["Statistics`DescriptiveStatistics`"];

AverageTimeToFactorNBitInteger[n_, samples_:1000]:=
    {n, Mean[Table[TimeToFactorInteger[RandomNBitInteger[n]][[1]], {samples}]]}
(*
:[font = input; preserveAspect; startGroup]
AverageTimeToFactorNBitInteger[40]
:[font = output; output; inactive; preserveAspect; endGroup]
{40, 0.04749999999999091}
;[o]
{40, 0.0475}
:[font = text; inactive; preserveAspect; endGroup]
Looks, ok, so let's try for the full plot of the average time to factor an n-
bit number for n=20 to n=60 bits in steps of 4 bits.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
The first plot generated is a sub-exponential fit to the data. The second plot is an exponential fit and the last plot is a log plot of the timing data.
:[font = input; preserveAspect; startGroup]
PlotTimeToFactorInteger[20, 50, 4, 10000]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; startGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.0147151 2.55915 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n \(bits\))] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .14267 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .27063 1 0 0 Minner Mrotsboxa
[(0.15)] -0.0125 .39859 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .52654 1 0 0 Minner Mrotsboxa
[(Time \(seconds\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .14267 m
1 .14267 L
s
P
p
0 0 .5 r
.001 w
0 .27063 m
1 .27063 L
s
P
p
0 0 .5 r
.001 w
0 .39859 m
1 .39859 L
s
P
p
0 0 .5 r
.001 w
0 .52654 m
1 .52654 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n \(bits\))] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .14267 m
.00625 .14267 L
s
P
[(0.05)] -0.0125 .14267 1 0 0 Minner Mrotshowa
p
.002 w
0 .27063 m
.00625 .27063 L
s
P
[(0.1)] -0.0125 .27063 1 0 0 Minner Mrotshowa
p
.002 w
0 .39859 m
.00625 .39859 L
s
P
[(0.15)] -0.0125 .39859 1 0 0 Minner Mrotshowa
p
.002 w
0 .52654 m
.00625 .52654 L
s
P
[(0.2)] -0.0125 .52654 1 0 0 Minner Mrotshowa
p
.001 w
0 .04031 m
.00375 .04031 L
s
P
p
.001 w
0 .0659 m
.00375 .0659 L
s
P
p
.001 w
0 .09149 m
.00375 .09149 L
s
P
p
.001 w
0 .11708 m
.00375 .11708 L
s
P
p
.001 w
0 .16826 m
.00375 .16826 L
s
P
p
.001 w
0 .19386 m
.00375 .19386 L
s
P
p
.001 w
0 .21945 m
.00375 .21945 L
s
P
p
.001 w
0 .24504 m
.00375 .24504 L
s
P
p
.001 w
0 .29622 m
.00375 .29622 L
s
P
p
.001 w
0 .32181 m
.00375 .32181 L
s
P
p
.001 w
0 .3474 m
.00375 .3474 L
s
P
p
.001 w
0 .373 m
.00375 .373 L
s
P
p
.001 w
0 .42418 m
.00375 .42418 L
s
P
p
.001 w
0 .44977 m
.00375 .44977 L
s
P
p
.001 w
0 .47536 m
.00375 .47536 L
s
P
p
.001 w
0 .50095 m
.00375 .50095 L
s
P
p
.001 w
0 .55214 m
.00375 .55214 L
s
P
p
.001 w
0 .57773 m
.00375 .57773 L
s
P
p
.001 w
0 .60332 m
.00375 .60332 L
s
P
[(Time \(seconds\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .14267 m
1 .14267 L
s
P
p
.002 w
.99375 .27063 m
1 .27063 L
s
P
p
.002 w
.99375 .39859 m
1 .39859 L
s
P
p
.002 w
.99375 .52654 m
1 .52654 L
s
P
p
.001 w
.99625 .04031 m
1 .04031 L
s
P
p
.001 w
.99625 .0659 m
1 .0659 L
s
P
p
.001 w
.99625 .09149 m
1 .09149 L
s
P
p
.001 w
.99625 .11708 m
1 .11708 L
s
P
p
.001 w
.99625 .16826 m
1 .16826 L
s
P
p
.001 w
.99625 .19386 m
1 .19386 L
s
P
p
.001 w
.99625 .21945 m
1 .21945 L
s
P
p
.001 w
.99625 .24504 m
1 .24504 L
s
P
p
.001 w
.99625 .29622 m
1 .29622 L
s
P
p
.001 w
.99625 .32181 m
1 .32181 L
s
P
p
.001 w
.99625 .3474 m
1 .3474 L
s
P
p
.001 w
.99625 .373 m
1 .373 L
s
P
p
.001 w
.99625 .42418 m
1 .42418 L
s
P
p
.001 w
.99625 .44977 m
1 .44977 L
s
P
p
.001 w
.99625 .47536 m
1 .47536 L
s
P
p
.001 w
.99625 .50095 m
1 .50095 L
s
P
p
.001 w
.99625 .55214 m
1 .55214 L
s
P
p
.001 w
.99625 .57773 m
1 .57773 L
s
P
p
.001 w
.99625 .60332 m
1 .60332 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
[ .02 .02 ] 0 setdash
.7 g
p
2 Mabswid
.02381 .01619 m
.06349 .01674 L
.10317 .01748 L
.14286 .01846 L
.18254 .01973 L
.22222 .02139 L
.2619 .02352 L
.30159 .02627 L
.34127 .02976 L
.38095 .0342 L
.42063 .03981 L
.46032 .04685 L
.5 .05567 L
.53968 .06665 L
.57937 .08029 L
.61905 .09715 L
.65873 .11792 L
.69841 .14342 L
.7381 .17462 L
.77778 .21268 L
.81746 .25896 L
.85714 .31508 L
.89683 .38295 L
.93651 .46479 L
.97619 .56323 L
s
P
P
p
p
.02 w
.02381 .018 Mdot
.15986 .01787 Mdot
.29592 .01949 Mdot
.43197 .03476 Mdot
.56803 .08855 Mdot
.70408 .19113 Mdot
.84014 .31708 Mdot
.97619 .60332 Mdot
P
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.0147151 2.20366 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n \(bits\))] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .1249 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .23508 1 0 0 Minner Mrotsboxa
[(0.15)] -0.0125 .34526 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .45545 1 0 0 Minner Mrotsboxa
[(0.25)] -0.0125 .56563 1 0 0 Minner Mrotsboxa
[(Time \(seconds\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .1249 m
1 .1249 L
s
P
p
0 0 .5 r
.001 w
0 .23508 m
1 .23508 L
s
P
p
0 0 .5 r
.001 w
0 .34526 m
1 .34526 L
s
P
p
0 0 .5 r
.001 w
0 .45545 m
1 .45545 L
s
P
p
0 0 .5 r
.001 w
0 .56563 m
1 .56563 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n \(bits\))] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .1249 m
.00625 .1249 L
s
P
[(0.05)] -0.0125 .1249 1 0 0 Minner Mrotshowa
p
.002 w
0 .23508 m
.00625 .23508 L
s
P
[(0.1)] -0.0125 .23508 1 0 0 Minner Mrotshowa
p
.002 w
0 .34526 m
.00625 .34526 L
s
P
[(0.15)] -0.0125 .34526 1 0 0 Minner Mrotshowa
p
.002 w
0 .45545 m
.00625 .45545 L
s
P
[(0.2)] -0.0125 .45545 1 0 0 Minner Mrotshowa
p
.002 w
0 .56563 m
.00625 .56563 L
s
P
[(0.25)] -0.0125 .56563 1 0 0 Minner Mrotshowa
p
.001 w
0 .03675 m
.00375 .03675 L
s
P
p
.001 w
0 .05879 m
.00375 .05879 L
s
P
p
.001 w
0 .08082 m
.00375 .08082 L
s
P
p
.001 w
0 .10286 m
.00375 .10286 L
s
P
p
.001 w
0 .14693 m
.00375 .14693 L
s
P
p
.001 w
0 .16897 m
.00375 .16897 L
s
P
p
.001 w
0 .19101 m
.00375 .19101 L
s
P
p
.001 w
0 .21304 m
.00375 .21304 L
s
P
p
.001 w
0 .25712 m
.00375 .25712 L
s
P
p
.001 w
0 .27915 m
.00375 .27915 L
s
P
p
.001 w
0 .30119 m
.00375 .30119 L
s
P
p
.001 w
0 .32323 m
.00375 .32323 L
s
P
p
.001 w
0 .3673 m
.00375 .3673 L
s
P
p
.001 w
0 .38934 m
.00375 .38934 L
s
P
p
.001 w
0 .41137 m
.00375 .41137 L
s
P
p
.001 w
0 .43341 m
.00375 .43341 L
s
P
p
.001 w
0 .47748 m
.00375 .47748 L
s
P
p
.001 w
0 .49952 m
.00375 .49952 L
s
P
p
.001 w
0 .52156 m
.00375 .52156 L
s
P
p
.001 w
0 .54359 m
.00375 .54359 L
s
P
p
.001 w
0 .58767 m
.00375 .58767 L
s
P
p
.001 w
0 .6097 m
.00375 .6097 L
s
P
[(Time \(seconds\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .1249 m
1 .1249 L
s
P
p
.002 w
.99375 .23508 m
1 .23508 L
s
P
p
.002 w
.99375 .34526 m
1 .34526 L
s
P
p
.002 w
.99375 .45545 m
1 .45545 L
s
P
p
.002 w
.99375 .56563 m
1 .56563 L
s
P
p
.001 w
.99625 .03675 m
1 .03675 L
s
P
p
.001 w
.99625 .05879 m
1 .05879 L
s
P
p
.001 w
.99625 .08082 m
1 .08082 L
s
P
p
.001 w
.99625 .10286 m
1 .10286 L
s
P
p
.001 w
.99625 .14693 m
1 .14693 L
s
P
p
.001 w
.99625 .16897 m
1 .16897 L
s
P
p
.001 w
.99625 .19101 m
1 .19101 L
s
P
p
.001 w
.99625 .21304 m
1 .21304 L
s
P
p
.001 w
.99625 .25712 m
1 .25712 L
s
P
p
.001 w
.99625 .27915 m
1 .27915 L
s
P
p
.001 w
.99625 .30119 m
1 .30119 L
s
P
p
.001 w
.99625 .32323 m
1 .32323 L
s
P
p
.001 w
.99625 .3673 m
1 .3673 L
s
P
p
.001 w
.99625 .38934 m
1 .38934 L
s
P
p
.001 w
.99625 .41137 m
1 .41137 L
s
P
p
.001 w
.99625 .43341 m
1 .43341 L
s
P
p
.001 w
.99625 .47748 m
1 .47748 L
s
P
p
.001 w
.99625 .49952 m
1 .49952 L
s
P
p
.001 w
.99625 .52156 m
1 .52156 L
s
P
p
.001 w
.99625 .54359 m
1 .54359 L
s
P
p
.001 w
.99625 .58767 m
1 .58767 L
s
P
p
.001 w
.99625 .6097 m
1 .6097 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
[ .02 .02 ] 0 setdash
p
2 Mabswid
.02381 .01627 m
.06349 .0167 L
.10317 .01726 L
.14286 .01797 L
.18254 .01889 L
.22222 .02006 L
.2619 .02156 L
.30159 .02348 L
.34127 .02595 L
.38095 .0291 L
.42063 .03314 L
.46032 .03831 L
.5 .04493 L
.53968 .05342 L
.57937 .06428 L
.61905 .0782 L
.65873 .09602 L
.69841 .11885 L
.7381 .14808 L
.77778 .18553 L
.81746 .23348 L
.85714 .2949 L
.89683 .37356 L
.93651 .4743 L
.97619 .60332 L
s
P
P
p
p
.02 w
.02381 .01754 Mdot
.15986 .01743 Mdot
.29592 .01883 Mdot
.43197 .03198 Mdot
.56803 .07829 Mdot
.70408 .16662 Mdot
.84014 .27508 Mdot
.97619 .52156 Mdot
P
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-0.656463 0.0340136 0.768774 0.259223 [
[(20)] .02381 0 0 2 0 Minner Mrotsboxa
[(25)] .19388 0 0 2 0 Minner Mrotsboxa
[(30)] .36395 0 0 2 0 Minner Mrotsboxa
[(35)] .53401 0 0 2 0 Minner Mrotsboxa
[(40)] .70408 0 0 2 0 Minner Mrotsboxa
[(45)] .87415 0 0 2 0 Minner Mrotsboxa
[(Size of n \(bits\))] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.002)] -0.0125 .06914 1 0 0 Minner Mrotsboxa
[(0.005)] -0.0125 .17229 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .25033 1 0 0 Minner Mrotsboxa
[(0.02)] -0.0125 .32836 1 0 0 Minner Mrotsboxa
[(0.05)] -0.0125 .43152 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .50955 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .58758 1 0 0 Minner Mrotsboxa
[(Time \(seconds\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.19388 0 m
.19388 .61803 L
s
P
p
0 0 .5 r
.001 w
.36395 0 m
.36395 .61803 L
s
P
p
0 0 .5 r
.001 w
.53401 0 m
.53401 .61803 L
s
P
p
0 0 .5 r
.001 w
.70408 0 m
.70408 .61803 L
s
P
p
0 0 .5 r
.001 w
.87415 0 m
.87415 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .06914 m
1 .06914 L
s
P
p
0 0 .5 r
.001 w
0 .17229 m
1 .17229 L
s
P
p
0 0 .5 r
.001 w
0 .25033 m
1 .25033 L
s
P
p
0 0 .5 r
.001 w
0 .32836 m
1 .32836 L
s
P
p
0 0 .5 r
.001 w
0 .43152 m
1 .43152 L
s
P
p
0 0 .5 r
.001 w
0 .50955 m
1 .50955 L
s
P
p
0 0 .5 r
.001 w
0 .58758 m
1 .58758 L
s
P
p
0 0 .5 r
.001 w
0 .11479 m
1 .11479 L
s
P
p
0 0 .5 r
.001 w
0 .14717 m
1 .14717 L
s
P
p
0 0 .5 r
.001 w
0 .19282 m
1 .19282 L
s
P
p
0 0 .5 r
.001 w
0 .21017 m
1 .21017 L
s
P
p
0 0 .5 r
.001 w
0 .22521 m
1 .22521 L
s
P
p
0 0 .5 r
.001 w
0 .23847 m
1 .23847 L
s
P
p
0 0 .5 r
.001 w
0 .37401 m
1 .37401 L
s
P
p
0 0 .5 r
.001 w
0 .4064 m
1 .4064 L
s
P
p
0 0 .5 r
.001 w
0 .45204 m
1 .45204 L
s
P
p
0 0 .5 r
.001 w
0 .4694 m
1 .4694 L
s
P
p
0 0 .5 r
.001 w
0 .48443 m
1 .48443 L
s
P
p
0 0 .5 r
.001 w
0 .49769 m
1 .49769 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(20)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.19388 0 m
.19388 .00625 L
s
P
[(25)] .19388 0 0 2 0 Minner Mrotshowa
p
.002 w
.36395 0 m
.36395 .00625 L
s
P
[(30)] .36395 0 0 2 0 Minner Mrotshowa
p
.002 w
.53401 0 m
.53401 .00625 L
s
P
[(35)] .53401 0 0 2 0 Minner Mrotshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(40)] .70408 0 0 2 0 Minner Mrotshowa
p
.002 w
.87415 0 m
.87415 .00625 L
s
P
[(45)] .87415 0 0 2 0 Minner Mrotshowa
p
.001 w
.05782 0 m
.05782 .00375 L
s
P
p
.001 w
.09184 0 m
.09184 .00375 L
s
P
p
.001 w
.12585 0 m
.12585 .00375 L
s
P
p
.001 w
.15986 0 m
.15986 .00375 L
s
P
p
.001 w
.22789 0 m
.22789 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.29592 0 m
.29592 .00375 L
s
P
p
.001 w
.32993 0 m
.32993 .00375 L
s
P
p
.001 w
.39796 0 m
.39796 .00375 L
s
P
p
.001 w
.43197 0 m
.43197 .00375 L
s
P
p
.001 w
.46599 0 m
.46599 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.56803 0 m
.56803 .00375 L
s
P
p
.001 w
.60204 0 m
.60204 .00375 L
s
P
p
.001 w
.63605 0 m
.63605 .00375 L
s
P
p
.001 w
.67007 0 m
.67007 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.77211 0 m
.77211 .00375 L
s
P
p
.001 w
.80612 0 m
.80612 .00375 L
s
P
p
.001 w
.84014 0 m
.84014 .00375 L
s
P
p
.001 w
.90816 0 m
.90816 .00375 L
s
P
p
.001 w
.94218 0 m
.94218 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Size of n \(bits\))] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .06914 m
.00625 .06914 L
s
P
[(0.002)] -0.0125 .06914 1 0 0 Minner Mrotshowa
p
.002 w
0 .17229 m
.00625 .17229 L
s
P
[(0.005)] -0.0125 .17229 1 0 0 Minner Mrotshowa
p
.002 w
0 .25033 m
.00625 .25033 L
s
P
[(0.01)] -0.0125 .25033 1 0 0 Minner Mrotshowa
p
.002 w
0 .32836 m
.00625 .32836 L
s
P
[(0.02)] -0.0125 .32836 1 0 0 Minner Mrotshowa
p
.002 w
0 .43152 m
.00625 .43152 L
s
P
[(0.05)] -0.0125 .43152 1 0 0 Minner Mrotshowa
p
.002 w
0 .50955 m
.00625 .50955 L
s
P
[(0.1)] -0.0125 .50955 1 0 0 Minner Mrotshowa
p
.002 w
0 .58758 m
.00625 .58758 L
s
P
[(0.2)] -0.0125 .58758 1 0 0 Minner Mrotshowa
p
.001 w
0 .11479 m
.00375 .11479 L
s
P
p
.001 w
0 .14717 m
.00375 .14717 L
s
P
p
.001 w
0 .19282 m
.00375 .19282 L
s
P
p
.001 w
0 .21017 m
.00375 .21017 L
s
P
p
.001 w
0 .22521 m
.00375 .22521 L
s
P
p
.001 w
0 .23847 m
.00375 .23847 L
s
P
p
.001 w
0 .37401 m
.00375 .37401 L
s
P
p
.001 w
0 .4064 m
.00375 .4064 L
s
P
p
.001 w
0 .45204 m
.00375 .45204 L
s
P
p
.001 w
0 .4694 m
.00375 .4694 L
s
P
p
.001 w
0 .48443 m
.00375 .48443 L
s
P
p
.001 w
0 .49769 m
.00375 .49769 L
s
P
[(Time \(seconds\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.19388 .61178 m
.19388 .61803 L
s
P
p
.002 w
.36395 .61178 m
.36395 .61803 L
s
P
p
.002 w
.53401 .61178 m
.53401 .61803 L
s
P
p
.002 w
.70408 .61178 m
.70408 .61803 L
s
P
p
.002 w
.87415 .61178 m
.87415 .61803 L
s
P
p
.001 w
.05782 .61428 m
.05782 .61803 L
s
P
p
.001 w
.09184 .61428 m
.09184 .61803 L
s
P
p
.001 w
.12585 .61428 m
.12585 .61803 L
s
P
p
.001 w
.15986 .61428 m
.15986 .61803 L
s
P
p
.001 w
.22789 .61428 m
.22789 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.29592 .61428 m
.29592 .61803 L
s
P
p
.001 w
.32993 .61428 m
.32993 .61803 L
s
P
p
.001 w
.39796 .61428 m
.39796 .61803 L
s
P
p
.001 w
.43197 .61428 m
.43197 .61803 L
s
P
p
.001 w
.46599 .61428 m
.46599 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.56803 .61428 m
.56803 .61803 L
s
P
p
.001 w
.60204 .61428 m
.60204 .61803 L
s
P
p
.001 w
.63605 .61428 m
.63605 .61803 L
s
P
p
.001 w
.67007 .61428 m
.67007 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.77211 .61428 m
.77211 .61803 L
s
P
p
.001 w
.80612 .61428 m
.80612 .61803 L
s
P
p
.001 w
.84014 .61428 m
.84014 .61803 L
s
P
p
.001 w
.90816 .61428 m
.90816 .61803 L
s
P
p
.001 w
.94218 .61428 m
.94218 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .06914 m
1 .06914 L
s
P
p
.002 w
.99375 .17229 m
1 .17229 L
s
P
p
.002 w
.99375 .25033 m
1 .25033 L
s
P
p
.002 w
.99375 .32836 m
1 .32836 L
s
P
p
.002 w
.99375 .43152 m
1 .43152 L
s
P
p
.002 w
.99375 .50955 m
1 .50955 L
s
P
p
.002 w
.99375 .58758 m
1 .58758 L
s
P
p
.001 w
.99625 .11479 m
1 .11479 L
s
P
p
.001 w
.99625 .14717 m
1 .14717 L
s
P
p
.001 w
.99625 .19282 m
1 .19282 L
s
P
p
.001 w
.99625 .21017 m
1 .21017 L
s
P
p
.001 w
.99625 .22521 m
1 .22521 L
s
P
p
.001 w
.99625 .23847 m
1 .23847 L
s
P
p
.001 w
.99625 .37401 m
1 .37401 L
s
P
p
.001 w
.99625 .4064 m
1 .4064 L
s
P
p
.001 w
.99625 .45204 m
1 .45204 L
s
P
p
.001 w
.99625 .4694 m
1 .4694 L
s
P
p
.001 w
.99625 .48443 m
1 .48443 L
s
P
p
.001 w
.99625 .49769 m
1 .49769 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
.02381 .01919 Mdot
.15986 .01472 Mdot
.29592 .06137 Mdot
.43197 .22284 Mdot
.56803 .36961 Mdot
.70408 .46767 Mdot
.84014 .52833 Mdot
.97619 .60332 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Code hidden here ...
:[font = input; initialization; preserveAspect; endGroup]
*)
Needs["Graphics`Graphics`"];

PlotTimeToFactorInteger[minBits_, maxBits_, stepSize_, samples_:1000]:=
	Module[{none},
		data = Table[AverageTimeToFactorNBitInteger[n], 
		             {n, minBits, maxBits, stepSize}];
		FitSubExponential[data];
		FitExponential[data];
		LogListPlot[data,
		         PlotRange->All,
		         PlotStyle->PointSize[0.02],
		         Frame->True,
		         FrameLabel->{"Size of n (bits)", "Time (seconds)", "",""},
		         GridLines->Automatic]
	]
	            
(*
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Fit a Sub-exponential to the data i.e. data ~ exp(x^(1/3) (ln(x))^(2/3))
:[font = input; initialization; preserveAspect; endGroup]
*)
FitSubExponential[data_]:=
	Module[{logData},
	    Clear[x];
	    xVals = Map[#[[1]]&, data];
		logData = Map[{#[[1]], Log[#[[2]]]}&, data];
		formula = Fit[logData, {1, x^(1/3) Log[x]^(2/3)}, x];
		
		Show[Plot[Exp[formula], {x, Min[xVals], Max[xVals]},
		          PlotStyle->{{AbsoluteThickness[2], Dashing[{0.02,0.02}], GrayLevel[0.7]}},
		          DisplayFunction->Identity],
		     ListPlot[data, 
		              PlotStyle->PointSize[0.02],
		              DisplayFunction->Identity],
		     Frame->True,
		     FrameLabel->{"Size of n (bits)", "Time (seconds)"},
		     GridLines->Automatic,
		     DisplayFunction :> $DisplayFunction]
	]
	
(*
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Fit an exponential to the data i.e. data ~ exp(x) 
:[font = input; initialization; preserveAspect; endGroup; endGroup; endGroup]
*)
FitExponential[data_]:=
	Module[{logData},
	    Clear[x];
	    xVals = Map[#[[1]]&, data];
		logData = Map[{#[[1]], Log[#[[2]]]}&, data];
		formula = Fit[logData, {1, x}, x];
		
		Show[Plot[Exp[formula], {x, Min[xVals], Max[xVals]},
		          PlotStyle->{{AbsoluteThickness[2], Dashing[{0.02,0.02}], GrayLevel[0]}},
		          DisplayFunction->Identity],
		     ListPlot[data, 
		              PlotStyle->PointSize[0.02],
		              DisplayFunction->Identity],
		     Frame->True,
		     FrameLabel->{"Size of n (bits)", "Time (seconds)"},
		     GridLines->Automatic,
		     DisplayFunction:>$DisplayFunction]
	]
(*
^*)
